;*******************************
;*    DEMONTRATION PROGRAM 0   *
;*        INPUT (DIP SW.)      *
;*******************************
;
            ORG    8000H
DIPSW       EQU    0E0A0H
PORTA       EQU    0E0B8H
PORTB       EQU    0E0B9H
PORTC       EQU    0E0BAH
CTRL        EQU    0E0BBH
U28PA       EQU    0E0B4H
U28PB       EQU    0E0B5H
U28PC       EQU    0E0B6H
U28CTRL     EQU    0E0B7H
SEG_PORT    EQU    PORTB
SYSCALL     EQU    0030H

CP3DEM0:    MOV    DPTR,#SEG_PORT
            MOV    R1,DPL
            MOV    DPTR,#CTRL
            MOV    P2,DPH
            MOV    R0,DPL
            MOV    A,#80H
            MOVX   @R0,A         ;Port = P2:R0

            MOV    DPTR,#U28CTRL
            MOV    A,#81H
            MOVX   @DPTR,A
            MOV    DPTR,#U28PA
            MOV    A,#0FFH
            MOVX   @DPTR,A
            INC    DPTR
            CLR    A
            MOVX   @DPTR,A

            MOV    DPTR,#DIPSW
            MOV    R0,DPL
            MOVX   A,@R0         ;Read dip switch
            CPL    A
            MOV    R3,A
            MOV    R2,#3FH       ;"0"
            MOV    DPTR,#PORTC

START:      MOV    A,R2
            MOVX   @R1,A        ;Write to 7-segment
            MOV    A,R3
            MOVX   @DPTR,A
            LCALL  DELAY
            CLR    A
            MOVX   @R1,A        ;Clear 7-segment
            CALL   DELAY
            LCALL  CHK_DIP
            SJMP   START

;*
;* Check dip sw.
;*
CHK_DIP:    MOVX   A,@R0        ;Read DIP SW.
            CPL    A
            MOV    B,A
            XRL    A,R3
            JZ     OUT_CHKDP
            MOV    R3,B
            MOV    R4,#8
CKDP0:      RLC    A
            JC     CKDP1        ;Bit changed
            DJNZ   R4,CKDP0
            SJMP   OUT_CHKDP    ;No bit changed
CKDP1:      MOV    A,#9
            CLR    CY
            SUBB   A,R4
            MOV    B,A
            MOV    A,#15H       ;Hex to segment
            LCALL  SYSCALL
            MOV    R2,A
OUT_CHKDP:  RET

DELAY:      PUSH   DPH
            PUSH   DPL
            MOV    DPTR,#4000H
DLY1:       INC    DPTR
            MOV    A,DPH
            ORL    A,DPL
            JNZ    DLY1
            POP    DPL
            POP    DPH
            RET

            END

